import moment from 'moment'



export function fill_missing_dates(labels, graphData, format = "DD-MM-YYYY") {
    for (let i = 0; i < labels.length; i++) {
        //make sure we are not checking the last date in the labels array
        if (i + 1 < labels.length) {
            let date1 = moment(labels[i], format);
            let date2 = moment(labels[i + 1], format);

            //if the current date +1 is not the same as it's next neighbor we have to add in a new one
            if (!date1.add(1, "days").isSame(date2)) {

                //add the label
                labels.splice(i + 1, 0, date1.format(format));
                //add the data
                graphData.splice(i + 1, 0, 0);
            }
        }
    }
}
